Scriptname TOX_PlayerScript extends ReferenceAlias 

GlobalVariable Property TOX_Magnitude Auto
GlobalVariable Property TOX_Divider Auto
GlobalVariable Property TOX_Toxicity Auto
GlobalVariable Property TOX_Recovery Auto
GlobalVariable Property TOX_UpdateTime Auto
GlobalVariable Property timescale Auto
;GlobalVariable Property TOX_Notif Auto
GlobalVariable Property HealthPenaltyPercent Auto

MagicEffect Property AlchFortifyHealth Auto
MagicEffect Property AlchCureDisease Auto
MagicEffect Property AlchCurePoison Auto

Actor Property PlayerREF Auto
;Spell Property TOX_Display Auto
;Keyword Property MagicAlchBeneficial Auto
Keyword Property VendorItemPotion Auto

float gametime
float sleeptime

Event OnInIt()
	
	RegisterForSingleUpdateGameTime(0.2)
	gametime = Utility.GetCurrentGameTime()
	RegisterForMenu("Sleep/Wait Menu")
	
endEvent

Event OnMenuOpen(String MenuName)

	if (MenuName == "Sleep/Wait Menu")
		gametime = Utility.GetCurrentGameTime()
		RegisterForSleep()
	endif
	
EndEvent

Event OnMenuClose(String MenuName)

	if (MenuName == "Sleep/Wait Menu")
		
		float newGT = Utility.GetCurrentGameTime()
		
		int TS = timescale.GetValue() as Int
		
		int toxreduction = ((newGT - gametime)*24*60*60/TS/TOX_UpdateTime.GetValue()*TOX_Recovery.GetValue()*(PlayerREF.GetActorValueMax("Health") + mag)/100) as Int
		
		int mag = TOX_Toxicity.GetValue() as Int
		
		if (toxreduction > mag)
			toxreduction = mag
		endif
		
		TOX_Toxicity.Mod(-toxreduction)
		PlayerREF.ModActorValue("Health", toxreduction)
		UpdateToxicityDisplay()
		
	endif
	
EndEvent

Event OnSleepStart(float afSleepStartTime, float afDesiredSleepEndTime)
	
	gametime = afSleepStartTime
	
endEvent

Event OnSleepStop(bool abInterrupted)
	
	UnregisterForUpdate()
		
	float newGT2 = Utility.GetCurrentGameTime()
		
	int TS = timescale.GetValue() as Int
	
	int toxreduction = ((newGT2 - gametime)*24*60*60/TS/TOX_UpdateTime.GetValue()*TOX_Recovery.GetValue()*(PlayerREF.GetActorValueMax("Health") + mag)/100) as Int
		
	int mag = TOX_Toxicity.GetValue() as Int
		
	if (toxreduction > mag)
		toxreduction = mag
	endif
	
	TOX_Toxicity.Mod(-toxreduction)
	PlayerREF.ModActorValue("Health", toxreduction)
	UpdateToxicityDisplay()
	
endEvent

Event OnUpdate()
	
	int toxreduction = TOX_Recovery.GetValue() as Int
	
	int mag = TOX_Toxicity.GetValue() as Int
		
	if (toxreduction > mag)
		toxreduction = mag
	endif
	
	TOX_Toxicity.Mod(-toxreduction)
	PlayerREF.ModActorValue("Health", toxreduction)
	UpdateToxicityDisplay()
	
endEvent

Event OnObjectEquipped(Form akBaseObject, ObjectReference akReference)
	
	if (akBaseObject.HasKeyword(VendorItemPotion))
	
		float multiplier = 1
		if ((akBaseObject as Potion).GetNthEffectMagicEffect(0)==AlchFortifyHealth)
			multiplier = 0.25
		elseif (((akBaseObject as Potion).GetNthEffectMagicEffect(0)==AlchCureDisease) || ((akBaseObject as Potion).GetNthEffectMagicEffect(0)==AlchCurePoison))
			multiplier = 0.1
		endIf
		float mag = TOX_Magnitude.GetValue()
		float div = TOX_Divider.GetValue()
		float value = akBaseObject.GetGoldValue()/div*multiplier
		
		;Debug.Notification(mag + ", "+ div + ", "+ value)
		
		int toxicity = (mag*(1 - 1/Math.pow(2, value))) as Int

		TOX_Toxicity.Mod(toxicity)
		PlayerREF.ModActorValue("Health", -toxicity)
		
		UpdateToxicityDisplay()

	endif
	
endEvent

Function UpdateToxicityDisplay()

	UnregisterForUpdate()

	int mag = TOX_Toxicity.GetValue() as Int
	int toxpercent = (100*mag/(PlayerREF.GetActorValueMax("Health") + mag)) as Int
	HealthPenaltyPercent.SetValue(toxpercent)
	
	if (mag > 0)
		RegisterForSingleUpdate(TOX_UpdateTime.GetValue())
	endif
	
endFunction